//===============================================================================================
// Object:			zContext
// Description:	Responsible for the help page context information
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

kTaxHelp =			"taxHelp";
kProgramHelp =		"programHelp";
kGovHelp =			"govInstructions";
kHyperHelp =		"hyper";
kFaqHelp =			"faq";
kAppFaqHelp =		"appFaq";
kVideoLib =			"videoLib";
kStaticHtmlHelp = "staticHtml";

kContextPrefixLen = 3;

function zContextType( name, type, prefix )
{
	this.name = ( name ) ? name.toLowerCase() : null;
		// English name
	this.type = ( type ) ? type.toLowerCase() : null;;
		// type name encoded into the index
	this.prefix = prefix;
		// filename prefix
}

kContextTypes = new Array(
	new zContextType(	kHyperHelp,			"hyper",			"hyp" ),
	new zContextType(	kProgramHelp,		"prghelp",		"prg" ),
	new zContextType(	kTaxHelp,			"taxhelp",		"tax" ),
	new zContextType(	kGovHelp,			"govinstr",		"gov" ),
	new zContextType(	kFaqHelp,			"faq",			"faq" ),
	new zContextType(	kAppFaqHelp,		"appfaq",		"app" ),
	new zContextType(	"taxHandbook",		"mmith",			"mmi" ),
	new zContextType(	"irsPubs",			"irspubs",		"irs" ),
	new zContextType(	"taxSaavy",			"savvy",			"sav" ),
	new zContextType(	kVideoLib,			kVideoLib,		"" ),
	new zContextType( kStaticHtmlHelp,  kStaticHtmlHelp, ""  )
);

kContextTypeCnt = kContextTypes.length;

//-----------------------------------------------------------------------------------------------
function findContextTypeByType( type )
{
	var tmpType = type.toLowerCase();
	
	for( var i=0; i<kContextTypeCnt; ++i )
	{
		if( tmpType == kContextTypes[i].type ) return kContextTypes[i];
	}
	
	return null;
}

//-----------------------------------------------------------------------------------------------
function findContextTypeByName( name )
{
	var tmpName = name.toLowerCase();
	
	for( var i=0; i<kContextTypeCnt; ++i )
	{
		if( tmpName == kContextTypes[i].name ) return kContextTypes[i];
	}

	return null;
}

//-----------------------------------------------------------------------------------------------
function findContextTypeByFilename( filename )
{
	if( filename.length < kContextPrefixLen ) return null;
	
	var prefix = filename.substr(0,3).toLowerCase();
	
	for( var i=0; i<kContextTypeCnt; ++i )
	{
		if( prefix == kContextTypes[i].prefix ) return kContextTypes[i];
	}

	return null;
}


//-----------------------------------------------------------------------------------------------
function findTaxHelpContext() { return findContextTypeByName( kTaxHelp ); }

//-----------------------------------------------------------------------------------------------
function findGovHelpContext()  { return findContextTypeByName( kGovHelp ); }


//-----------------------------------------------------------------------------------------------
// zContext
//-----------------------------------------------------------------------------------------------
function zContext( name, screenId, filename, formId, fieldId )
{
	if( filename ) this.filename = filename;
	if( formId ) this.formId = formId;
	if( fieldId ) this.fieldId = fieldId;

	// Determine the type based on the nice name
	if( name ) this.ctype = findContextTypeByName( name );
	else if( filename ) this.ctype = findContextTypeByFilename( filename );
	
	// Determine the filename if not specified based on the other specified fields
	if( !this.filename && screenId && this.ctype )
	{
		if( screenId )
		{
			// replace space in screenId with '_'
			screenId = screenId.replace( / /g, '_' );
		
			this.filename = this.ctype.prefix;
			this.filename += screenId.toLowerCase();
		}
		else this.filename = "";
	}
}

//-----------------------------------------------------------------------------------------------
p = zContext.prototype;

p.ctype = null;
p.filename = null;
p.formId = null;
p.fieldId = null;

p = null;
